% Function to copy the cavities at the other unit cells
function [inp, count, model] = draw_cavity_array(x, y, tag, inp, count, geom, model, workplane)

[xrot, yrot] = rotate(x, y, geom.mech.amech/2, 0, -60);
[xrot60, yrot60] = rotate(x, y, geom.mech.amech/2, 0, 60);

tri_side = geom.mech.amech - geom.mech.w*sqrt(3);
tri_a1_x = geom.mech.amech/2 + [geom.mech.w*sqrt(3)/2 geom.mech.w*sqrt(3)/2+tri_side/4 geom.mech.amech/2 geom.mech.amech/2];
tri_a1_y = [geom.mech.w/2 geom.mech.w/2+tri_side*sqrt(3)/4 geom.mech.amech/(2*sqrt(3)) geom.mech.w/2];

[tri_a2_x, tri_a2_y] = rotate(tri_a1_x, tri_a1_y, geom.mech.amech/2, 0, -120);
[tri_a3_x, tri_a3_y] = rotate(tri_a1_x, tri_a1_y, geom.mech.amech/2, 0, -240);

tri_b1_x = tri_a1_x;
tri_b1_y = -tri_a1_y;

[tri_b2_x, tri_b2_y] = rotate(tri_b1_x, tri_b1_y, geom.mech.amech/2, 0, -120);
[tri_b3_x, tri_b3_y] = rotate(tri_b1_x, tri_b1_y, geom.mech.amech/2, 0, -240);

l1_x = geom.mech.amech/2 + [geom.mech.r geom.mech.amech/2 geom.mech.amech/2 geom.mech.r];
l1_y = [geom.mech.w/2 geom.mech.w/2 -geom.mech.w/2 -geom.mech.w/2];

[l2_x, l2_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -60);
[l3_x, l3_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -120);
[l4_x, l4_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -180);
[l5_x, l5_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -240);
[l6_x, l6_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -300);

% plot(tri_a1_x, tri_a1_y, 'color', colour, 'LineWidth', 0.5);
% plot(tri_a2_x, tri_a2_y, 'color', colour, 'LineWidth', 0.5);
% plot(tri_a3_x, tri_a3_y, 'color', colour, 'LineWidth', 0.5);
% plot(tri_b1_x, tri_b1_y, 'color', colour, 'LineWidth', 0.5);

ina1 = inpolygon(x(1:end-1), y(1:end-1), tri_a1_x, tri_a1_y);
ina2 = inpolygon(x(1:end-1), y(1:end-1), tri_a2_x, tri_a2_y);
ina3 = inpolygon(x(1:end-1), y(1:end-1), tri_a3_x, tri_a3_y);
inb1 = inpolygon(x(1:end-1), y(1:end-1), tri_b1_x, tri_b1_y);
inb2 = inpolygon(x(1:end-1), y(1:end-1), tri_b2_x, tri_b2_y);
inb3 = inpolygon(x(1:end-1), y(1:end-1), tri_b3_x, tri_b3_y);
inl1 = inpolygon(x(1:end-1), y(1:end-1), l1_x, l1_y);
inl2 = inpolygon(x(1:end-1), y(1:end-1), l2_x, l2_y);
inl3 = inpolygon(x(1:end-1), y(1:end-1), l3_x, l3_y);
inl4 = inpolygon(x(1:end-1), y(1:end-1), l4_x, l4_y);
inl5 = inpolygon(x(1:end-1), y(1:end-1), l5_x, l5_y);
inl6 = inpolygon(x(1:end-1), y(1:end-1), l6_x, l6_y);

if sum(inl1)>0 && mean(y(1:end-1))>=geom.opt.r
    region = 'l1t';
elseif sum(inl1)>0 && mean(y(1:end-1))<=-geom.opt.r
    region = 'l1b';
elseif sum(inl1)>0 && abs(mean(y(1:end-1)))<geom.opt.r
    region = 'l1m';
elseif sum(inl2)>0 && mean(yrot60(1:end-1))>=geom.opt.r
    region = 'l2t';
elseif sum(inl2)>0 && mean(yrot60(1:end-1))<=-geom.opt.r
    region = 'l2b';
elseif sum(inl2)>0 && abs(mean(yrot60(1:end-1)))<geom.opt.r
    region = 'l2m';
elseif sum(inl3)>0 && mean(yrot(1:end-1))>=geom.opt.r
    region = 'l3t';
elseif sum(inl3)>0 && mean(yrot(1:end-1))<=-geom.opt.r
    region = 'l3b';
elseif sum(inl3)>0 && abs(mean(yrot(1:end-1)))<geom.opt.r
    region = 'l3m';
elseif sum(inl4)>0 && mean(y(1:end-1))>=geom.opt.r
    region = 'l4t';
elseif sum(inl4)>0 && mean(y(1:end-1))<=-geom.opt.r
    region = 'l4b';
elseif sum(inl4)>0 && abs(mean(y(1:end-1)))<geom.opt.r
    region = 'l4m';
elseif sum(inl5)>0 && mean(yrot60(1:end-1))>=geom.opt.r
    region = 'l5t';
elseif sum(inl5)>0 && mean(yrot60(1:end-1))<=-geom.opt.r
    region = 'l5b';
elseif sum(inl5)>0 && abs(mean(yrot60(1:end-1)))<geom.opt.r
    region = 'l5m';
elseif sum(inl6)>0 && mean(yrot(1:end-1))>=geom.opt.r
    region = 'l6t';
elseif sum(inl6)>0 && mean(yrot(1:end-1))<=-geom.opt.r
    region = 'l6b';
elseif sum(inl6)>0 && abs(mean(yrot(1:end-1)))<geom.opt.r
    region = 'l6m';
elseif sum(ina1)>0
    region = 'a1';
elseif sum(ina2)>0
    region = 'a2';
elseif sum(ina3)>0
    region = 'a3';
elseif sum(inb1)>0
    region = 'b1';
elseif sum(inb2)>0
    region = 'b2';
elseif sum(inb3)>0
    region = 'b3';
end

% x_cen = mean(x(1:end-1));
% y_cen = mean(y(1:end-1));

pol = workplane.geom.create(tag, 'Polygon');
pol.set('source', 'table');
l = 1;
for k=1:2:length(x)
    pol.setIndex('table', num2str(x(k),'%10.9e'), l-1, 0);
    pol.setIndex('table', num2str(y(k),'%10.9e'), l-1, 1);
    l = l+1;
end
                    
if strcmp(region, 'a1')
    if count.a1==1
        inp = rmfield(inp,'a1');
    end
    
    inp.a1(count.a1) = {tag};
    count.a1 = count.a1 + 1;
    
elseif strcmp(region, 'a2')
    if count.a2==1
        inp = rmfield(inp,'a2');
    end
    
    inp.a2(count.a2) = {tag};
    count.a2 = count.a2 + 1;
    
elseif strcmp(region, 'a3')
    if count.a3==1
        inp = rmfield(inp,'a3');
    end
    
    inp.a3(count.a3) = {tag};
    count.a3 = count.a3 + 1;
    
elseif strcmp(region, 'b1')
    if count.b1==1
        inp = rmfield(inp,'b1');
    end
    
    inp.b1(count.b1) = {tag};
    count.b1 = count.b1 + 1;
    
elseif strcmp(region, 'b2')
    if count.b2==1
        inp = rmfield(inp,'b2');
    end
    
    inp.b2(count.b2) = {tag};
    count.b2 = count.b2 + 1;
    
elseif strcmp(region, 'b3')
    if count.b3==1
        inp = rmfield(inp,'b3');
    end
    
    inp.b3(count.b3) = {tag};
    count.b3 = count.b3 + 1;
    
elseif strcmp(region, 'l1t')
    if count.l1t==1
        inp = rmfield(inp,'l1t');
    end
    
    inp.l1t(count.l1t) = {tag};
    count.l1t = count.l1t + 1;
    
elseif strcmp(region, 'l1b')
    if count.l1b==1
        inp = rmfield(inp,'l1b');
    end
    
    inp.l1b(count.l1b) = {tag};
    count.l1b = count.l1b + 1;
    
elseif strcmp(region, 'l1m')
    if count.l1m==1
        inp = rmfield(inp,'l1m');
    end
    
    inp.l1m(count.l1m) = {tag};
    count.l1m = count.l1m + 1;
    
elseif strcmp(region, 'l2t')
    if count.l2t==1
        inp = rmfield(inp,'l2t');
    end
    
    inp.l2t(count.l2t) = {tag};
    count.l2t = count.l2t + 1;
    
elseif strcmp(region, 'l2b')
    if count.l2b==1
        inp = rmfield(inp,'l2b');
    end
    
    inp.l2b(count.l2b) = {tag};
    count.l2b = count.l2b + 1;
    
elseif strcmp(region, 'l2m')
    if count.l2m==1
        inp = rmfield(inp,'l2m');
    end
    
    inp.l2m(count.l2m) = {tag};
    count.l2m = count.l2m + 1;
    
elseif strcmp(region, 'l3t')
    if count.l3t==1
        inp = rmfield(inp,'l3t');
    end
    
    inp.l3t(count.l3t) = {tag};
    count.l3t = count.l3t + 1;
    
elseif strcmp(region, 'l3b')
    if count.l3b==1
        inp = rmfield(inp,'l3b');
    end
    
    inp.l3b(count.l3b) = {tag};
    count.l3b = count.l3b + 1;
    
elseif strcmp(region, 'l3m')
    if count.l3m==1
        inp = rmfield(inp,'l3m');
    end
    
    inp.l3m(count.l3m) = {tag};
    count.l3m = count.l3m + 1;
    
elseif strcmp(region, 'l4t')
    if count.l4t==1
        inp = rmfield(inp,'l4t');
    end
    
    inp.l4t(count.l4t) = {tag};
    count.l4t = count.l4t + 1;
    
elseif strcmp(region, 'l4b')
    if count.l4b==1
        inp = rmfield(inp,'l4b');
    end
    
    inp.l4b(count.l4b) = {tag};
    count.l4b = count.l4b + 1;
    
elseif strcmp(region, 'l4m')
    if count.l4m==1
        inp = rmfield(inp,'l4m');
    end
    
    inp.l4m(count.l4m) = {tag};
    count.l4m = count.l4m + 1;

elseif strcmp(region, 'l5t')
    if count.l5t==1
        inp = rmfield(inp,'l5t');
    end
    
    inp.l5t(count.l5t) = {tag};
    count.l5t = count.l5t + 1;
    
elseif strcmp(region, 'l5b')
    if count.l5b==1
        inp = rmfield(inp,'l5b');
    end
    
    inp.l5b(count.l5b) = {tag};
    count.l5b = count.l5b + 1;
    
elseif strcmp(region, 'l5m')
    if count.l5m==1
        inp = rmfield(inp,'l5m');
    end
    
    inp.l5m(count.l5m) = {tag};
    count.l5m = count.l5m + 1;
    
elseif strcmp(region, 'l5')
    if count.l5==1
        inp = rmfield(inp,'l5');
    end
    
    inp.l5(count.l5) = {tag};
    count.l5 = count.l5 + 1;
    
elseif strcmp(region, 'l6t')
    if count.l6t==1
        inp = rmfield(inp,'l6t');
    end
    
    inp.l6t(count.l6t) = {tag};
    count.l6t = count.l6t + 1;
    
elseif strcmp(region, 'l6b')
    if count.l6b==1
        inp = rmfield(inp,'l6b');
    end
    
    inp.l6b(count.l6b) = {tag};
    count.l6b = count.l6b + 1;
    
elseif strcmp(region, 'l6m')
    if count.l6m==1
        inp = rmfield(inp,'l6m');
    end
    
    inp.l6m(count.l6m) = {tag};
    count.l6m = count.l6m + 1;
end

end
